// Macro Guard
#ifndef FEATDIST_TRAITS_H
#define FEATDIST_TRAITS_H

// Files included
#include "Exception.hpp"


namespace FeatDist {

  // enumerations
  enum StrandPolarity { PLUS, MINUS };
  enum Direction      { UPSTREAM, DOWNSTREAM };

  // typedefs
  typedef Exception<-1> InputError;
  typedef Exception<InputError::ID-1> ProgramError;
  typedef Exception<ProgramError::ID-1> HelpException;
  typedef std::pair<unsigned long, unsigned long> PType;
  typedef std::pair<StrandPolarity, std::string> SType;
  typedef std::pair< std::string, std::pair<SType, PType> > TType;


  // Variable declarations for namespace FeatDist
  extern const PType NADA;
  extern const std::string NOCHROM;
  extern const std::string NOID;
  extern const char SEP;
  extern const std::string CHROMOSOME;
  extern const std::string USESTDIN;

} // namespace FeatDist


#endif // FEATDIST_TRAITS_H
