// Author
//  Shane Neph : University of Washington

// Macro Guard
#ifndef SIGNALMAPDEFINITIONS_H
#define SIGNALMAPDEFINITIONS_H

// Files included
#include "Exception.hpp"
#include "StandardFiles.hpp"

namespace SignalMap {

  //======================================================
  // Typedefs, enums and static const's needed by program
  //======================================================
  typedef unsigned long CoordType;
  typedef std::pair<CoordType, CoordType> PType;
  typedef std::pair<double, CoordType> DType;
  typedef std::pair<std::string, DType> TType;
  typedef Exception<-1> InputError;
  typedef Exception<InputError::ID-1> ProgramError;
  extern const unsigned long MAXVAL;
  extern const std::string NOCHROM;
  extern const PType NADA;
  extern const DType NOGOOD;
  extern const TType NOGO;
  extern const char SEP;
  extern const std::string NANUMBER;
  extern const std::string CHROMOSOME;
  extern const long NUMFILES;
  enum MType { MEAN, MEDIAN, MAX, MIN, SUM, VARIANCE };

} // namespace SignalMap


#endif // SIGNALMAPDEFINITIONS_H
