// Author
//  Shane Neph : University of Washington

// Macro Guard
#ifndef SETOPS_TRAITS_H
#define SETOPS_TRAITS_H

// Files included
#include "Exception.hpp"


namespace SetOperations {

  // typedefs
  typedef Exception<-1> InputError;
  typedef Exception<InputError::ID-1> ProgramError;
  typedef Exception<ProgramError::ID-1> HelpException;
  typedef std::pair<unsigned long, unsigned long> PType;
  typedef std::pair<std::string, PType> TType;

  // enumerations
  enum ModeType { 
     MERGE, INTERSECTION, COMPLEMENT, DIFFERENCE, SYMMETRIC_DIFFERENCE,
     UNIONALL, ELEMENTOF, NOTELEMENTOF
                };


  // Variable declarations for namespace SetOperations
  extern const PType NADA;
  extern const std::string NOCHROM;
  extern const std::string NOCHROM_MINUS1;
  extern const TType NOGO;
  extern const TType CALLAGAIN;
  extern const char SEP;
  extern const std::string CHROMOSOME;
  extern const std::string NOREST;
  extern const std::string USESTDIN;

} // namespace SetOperations


#endif // SETOPS_TRAITS_H
