// Author
//  Shane Neph : University of Washington

// Macro Guard
#ifndef BED_READER_SETOPS_H
#define BED_READER_SETOPS_H

// Files included
#include "Assertion.hpp"
#include "ByLine.hpp"
#include "SetOpsDefns.hpp"



namespace SetOperations {

//===========
// BedReader
//===========
struct BedReader {
  // Constructor
  explicit BedReader(std::istream_iterator<ByLine>& is)
    : getNext_(true), coords_(std::make_pair(0, 0)),
      input_(is), eos_() {

    while ( input_ != eos_ ) { /* find first row of data */
      if (
           input_->find("chr") == 0 ||
           input_->find("chR") == 0 ||
           input_->find("cHr") == 0 ||
           input_->find("cHR") == 0 ||
           input_->find("Chr") == 0 ||
           input_->find("ChR") == 0 ||
           input_->find("CHr") == 0 ||
           input_->find("CHR") == 0
         ) {
        readIn();
        ++input_;
        getNext_ = false;
        break;
      }
      ++input_;
    } // while
  }

  // Public methods
  const std::string& Chrom() const { // call only after ReadLine()
    return(chrom_);
  }

  bool HasNext() {
    if ( !getNext_ )
      return(true);
    if ( input_ == eos_ || ReadLine() == NADA )
      return(false);
    getNext_ = false; // ReadLine() called
    return(true);
  }

  void PushBack() {
    getNext_ = false;
  }

  const PType& ReadLine() {
    if ( getNext_ ) {
      if ( input_->empty() )
        return(NADA);
      readIn();
      ++input_;
    }
    getNext_ = true;
    return(coords_);
  }

  std::string const* Rest() { // call only after ReadLine()
    return(&rest_);
  }

  ~BedReader() { /* */ }

private: // helpers
  void readIn() {
    /* Assume input row is good --> no error checking here */
    std::string::size_type pos = input_->find(SEP);
    std::string::size_type nex = input_->find(SEP, ++pos);
    std::string::size_type las = input_->find(SEP, ++nex);
    static const std::string::size_type sz = CHROMOSOME.size();
    chrom_ = input_->substr(sz, pos-sz-1);
    static const int base = 10;
    coords_.first = strtoul(
                            input_->substr(pos, nex-pos-1).c_str(),
                            NULL,
                            base
                           );
    rest_ = NOREST;
    if ( las != std::string::npos ) {
      coords_.second = strtoul(
                               input_->substr(nex, las-nex).c_str(),
                               NULL,
                               base
                              );
      if ( ++las < input_->size() )
        rest_ = input_->substr(las);
    }
    else
      coords_.second = strtoul(input_->substr(nex).c_str(), NULL, base);

    // coords_.second >= 1
    --coords_.second; // [a, b) --> [a, b-1]
  }

private:
  bool getNext_;
  PType coords_;
  std::istream_iterator<ByLine> input_, eos_;
  std::string chrom_;
  std::string rest_;
};

} // namespace SetOperations


#endif // BED_READER_SETOPS_H
