/*
  FILE: Cenomes.c
  AUTHOR: Scott Kuehn
  CREATE DATE: Thu May 18 08:10:51 PDT 2006
  PROJECT: CompBio
  ID: '$Id: Genomes.c,v 1.1 2006/05/22 20:12:29 skuehn Exp $'
*/

#include <string.h>
#include "Genomes.h"

const char *human_chroms[] = {"chr1", "chr1_random", "chr2", "chr2_random", "chr3", "chr3_random", "chr4", 
		       "chr4_random", "chr5", "chr5_random", "chr6", "chr6_random", "chr7", "chr7_random", 
		       "chr8", "chr8_random", "chr9", "chr9_random", "chr10", "chr10_random", "chr11", 
		       "chr11_random", "chr12", "chr12_random", "chr13", "chr13_random", "chr14", 
		       "chr14_random", "chr15", "chr15_random", "chr16", "chr16_random", "chr17", 
		       "chr17_random", "chr18", "chr18_random", "chr19", "chr19_random", "chr20", 
		       "chr20_random", "chr21", "chr21_random", "chr22", "chr22_random", "chrX", 
		       "chrX_random", "chrY", "chrY_random", "chrM", "chrM_random", "chrUn"};
const char *mouse_chroms[] = {"chr1", "chr1_random", "chr2", "chr2_random", "chr3", "chr3_random", "chr4", 
		       "chr4_random", "chr5", "chr5_random", "chr6", "chr6_random", "chr7", "chr7_random", 
		       "chr8", "chr8_random", "chr9", "chr9_random", "chr10", "chr10_random", "chr11", 
		       "chr11_random", "chr12", "chr12_random", "chr13", "chr13_random", "chr14", 
		       "chr14_random", "chr15", "chr15_random", "chr16", "chr16_random", "chr17", 
		       "chr17_random", "chr18", "chr18_random", "chr19", "chr19_random", "chrX", 
		       "chrX_random", "chrY", "chrY_random", "chrM", "chrM_random", "chrUn"};
const char *chimp_chroms[] = {"chr1", "chr1_random", "chr2", "chr2_random", "chr3", "chr3_random", "chr4", 
		       "chr4_random", "chr5", "chr5_random", "chr6", "chr6_random", "chr7", "chr7_random", 
		       "chr8", "chr8_random", "chr9", "chr9_random", "chr10", "chr10_random", "chr11", 
		       "chr11_random", "chr12", "chr12_random", "chr13", "chr13_random", "chr14", 
		       "chr14_random", "chr15", "chr15_random", "chr16", "chr16_random", "chr17", 
		       "chr17_random", "chr18", "chr18_random", "chr19", "chr19_random", "chr20", 
		       "chr20_random", "chr21", "chr21_random", "chr22", "chr22_random", "chrX", 
		       "chrX_random", "chrY", "chrY_random", "chrM", "chrM_random", "chrUn"};
const char *dog_chroms[] = {"chr1", "chr1_random", "chr2", "chr2_random", "chr3", "chr3_random", "chr4", 
			      "chr4_random", "chr5", "chr5_random", "chr6", "chr6_random", "chr7", "chr7_random", 
			      "chr8", "chr8_random", "chr9", "chr9_random", "chr10", "chr10_random", "chr11", 
			      "chr11_random", "chr12", "chr12_random", "chr13", "chr13_random", "chr14", 
			      "chr14_random", "chr15", "chr15_random", "chr16", "chr16_random", "chr17", 
			      "chr17_random", "chr18", "chr18_random", "chr19", "chr19_random", "chr20", 
			      "chr20_random", "chr21", "chr21_random", "chr22", "chr22_random", "chr23", 
			      "chr23_random", "chr24", "chr24_random", "chr25", "chr25_random", "chr26", 
			      "chr26_random", "chr27", "chr27_random", "chr28", "chr28_random", "chr29", 
			      "chr29_random", "chr30", "chr30_random", "chr31", "chr31_random", "chr32", 
			      "chr32_random", "chr33", "chr33_random", "chr34", "chr34_random", "chr35", 
			      "chr35_random", "chr36", "chr36_random", "chr37", "chr37_random", "chr38", 
			      "chr38_random", "chrX", "chrX_random", "chrM", "chrM_random", "chrUn"};
const char *yeast_chroms[] = {"chr1", "chr1_random", "chr2", "chr2_random", "chr3", "chr3_random", "chr4", 
				"chr4_random", "chr5", "chr5_random", "chr6", "chr6_random", "chr7", "chr7_random", 
				"chr8", "chr8_random", "chr9", "chr9_random", "chr10", "chr10_random", "chr11", 
				"chr11_random", "chr12", "chr12_random", "chr13", "chr13_random", "chr14", 
				"chr14_random", "chr15", "chr15_random", "chr16", "chr16_random", "chrM", 
				"chrM_random", "chrUn"};
const char *cow_chroms[] = {"chr1", "chr1_random", "chr2", "chr2_random", "chr3", "chr3_random", "chr4", 
			      "chr4_random", "chr5", "chr5_random", "chr6", "chr6_random", "chr7", "chr7_random", 
			      "chr8", "chr8_random", "chr9", "chr9_random", "chr10", "chr10_random", "chr11", 
			      "chr11_random", "chr12", "chr12_random", "chr13", "chr13_random", "chr14", 
			      "chr14_random", "chr15", "chr15_random", "chr16", "chr16_random", "chr17", 
			      "chr17_random", "chr18", "chr18_random", "chr19", "chr19_random", "chr20", 
			      "chr20_random", "chr21", "chr21_random", "chr22", "chr22_random", "chr23", 
			      "chr23_random", "chr24", "chr24_random", "chr25", "chr25_random", "chr26", 
			      "chr26_random", "chr27", "chr27_random", "chr28", "chr28_random", "chr29", 
			      "chr29_random", "chrX", "chrX_random", "chrM", "chrM_random", "chrUn"};
const char *rat_chroms[] = {"chr1", "chr1_random", "chr2", "chr2_random", "chr3", "chr3_random", "chr4", 
			      "chr4_random", "chr5", "chr5_random", "chr6", "chr6_random", "chr7", "chr7_random", 
			      "chr8", "chr8_random", "chr9", "chr9_random", "chr10", "chr10_random", "chr11", 
			      "chr11_random", "chr12", "chr12_random", "chr13", "chr13_random", "chr14", 
			      "chr14_random", "chr15", "chr15_random", "chr16", "chr16_random", "chr17", 
			      "chr17_random", "chr18", "chr18_random", "chr19", "chr19_random", "chr20",
			      "chr20_random", "chrX", "chrX_random", "chrUn"};
const char *zebrafish_chroms[] = {"chr1", "chr1_random", "chr2", "chr2_random", "chr3", "chr3_random", "chr4", 
				    "chr4_random", "chr5", "chr5_random", "chr6", "chr6_random", "chr7", "chr7_random", 
				    "chr8", "chr8_random", "chr9", "chr9_random", "chr10", "chr10_random", "chr11", 
				    "chr11_random", "chr12", "chr12_random", "chr13", "chr13_random", "chr14", 
				    "chr14_random", "chr15", "chr15_random", "chr16", "chr16_random", "chr17", 
				    "chr17_random", "chr18", "chr18_random", "chr19", "chr19_random", "chr20", 
				    "chr20_random", "chr21", "chr21_random", "chr22", "chr22_random", "chr23", 
				    "chr23_random", "chr24", "chr24_random", "chr25", "chr25_random", "chrM", 
				    "chrM_random", "chrUn"};
const char *tetraodon_chroms[] = {"chr1", "chr1_random", "chr2", "chr2_random", "chr3", "chr3_random", "chr4", 
				    "chr4_random", "chr5", "chr5_random", "chr6", "chr6_random", "chr7", "chr7_random", 
				    "chr8", "chr8_random", "chr9", "chr9_random", "chr10", "chr10_random", "chr11", 
				    "chr11_random", "chr12", "chr12_random", "chr13", "chr13_random", "chr14", 
				    "chr14_random", "chr15", "chr15_random", "chr16", "chr16_random", "chr17", 
				    "chr17_random", "chr18", "chr18_random", "chr19", "chr19_random", "chr20", 
				    "chr20_random", "chr21", "chr21_random", "chrUn"};
const char *fugu_chroms[] = {"chrUn"};
const char *worm_chroms[] = {"chrI", "chrII", "chrIII", "chrIV", "chrV", "chrX"};

const Genome human = {51, human_chroms};    
const Genome mouse = {45, mouse_chroms};
const Genome chimp = {51, chimp_chroms};
const Genome dog = {81, dog_chroms};
const Genome yeast = {35, yeast_chroms};
const Genome cow = {63, cow_chroms};
const Genome rat = {43, rat_chroms};
const Genome zebrafish = {53, zebrafish_chroms};
const Genome tetraodon = {43, tetraodon_chroms};
const Genome fugu = {1, fugu_chroms};
const Genome worm = {6, worm_chroms};


int chromIndex(const Genome *genome, char *chromName) {
  int i;

  for(i = 0; i < genome->numChroms; i++) {
    if(strncmp(chromName, genome->chroms[i], CHROM_NAME_LEN) == 0) {
      return i;
    }
  }
  return -1;
}
    
