
/*
  FILE: Cenomes.h
  AUTHOR: Scott Kuehn
  CREATE DATE: Thu May 18 08:10:51 PDT 2006
  PROJECT: CompBio
  ID: '$Id: Genomes.h,v 1.2 2006/09/11 19:09:05 skuehn Exp $'
*/

#ifndef GENOMES_H
#define GENOMES_H

#define CHROM_NAME_LEN 30
#define MAX_GENOME_NAME_LEN 127

typedef struct {
  int numChroms;
  const char **chroms;
} Genome;

extern const char *human_chroms[];
extern const char *mouse_chroms[];
extern const char *chimp_chroms[]; 
extern const char *dog_chroms[];
extern const char *yeast_chroms[];
extern const char *cow_chroms[];
extern const char *rat_chroms[];
extern const char *zebrafish_chroms[];
extern const char *tetraodon_chroms[];
extern const char *fugu_chroms[];
extern const char *worm_chroms[];

extern const Genome human;
extern const Genome mouse;
extern const Genome chimp;
extern const Genome dog;
extern const Genome yeast;
extern const Genome cow;
extern const Genome rat;
extern const Genome zebrafish;
extern const Genome tetraodon;
extern const Genome fugu;
extern const Genome worm;


int chromIndex(const Genome *genome, char *chromName);

#endif /* GENOMES_H */
