// Macro guard
#ifndef EXCEPTIONTEMPLATE_H
#define EXCEPTIONTEMPLATE_H

// Files included
#include "StandardFiles.hpp"


//==============================================================================
// Exception<int>
//  A simple mechanism allowing quick typedef'd exception types, differing only
//   by an integer template argument.  Inherits from std::exception.
// Example:  typedef Exception<1> BadInput;  
//           typedef Exception<2> UnknownError
//==============================================================================
template <int Value>
struct Exception : public std::exception {
  enum { ID = Value };

  explicit Exception(const std::string& msg) : msg_(msg) { /* */ }
  virtual ~Exception() throw() { /* */ }

  std::string GetMessage() const { return(msg_); }
private:
  std::string msg_;
};

#endif // EXCEPTIONTEMPLATE_H

