// Macro guard
#ifndef BYLINE_H
#define BYLINE_H

// Files included
#include "StandardFiles.hpp"

//==============================================================================
// ByLine structure:
//  Simple extension of the std::string class to allow reading input by lines
//   rather than by whitespace by default.
//==============================================================================
struct ByLine : public std::string {
  friend std::istream& operator>>(std::istream& is, ByLine& b) {
    std::getline(is, b);
    return(is);
  }
};

#endif // BYLINE_H

