/*
  FILE: Bed.h
  AUTHOR: Scott Kuehn
  CREATE DATE: Tue May 16 09:15:54 PDT 2006
  PROJECT: CompBio
*/

#ifndef BED_H
#define BED_H

#include <stdio.h>
#include "Genomes.h"

#define BED_FIELD_LEN 255
#define BED_LINE_LEN 1024
#define BED_RESID_LEN 500
#define NUM_BED_ITEMS_EST 100000
#define NUM_CHROM_EST 32

#define GT(A,B) ((A) > (B) ? 1 : 0)

/* Data Structures */
typedef struct {
  int startCoord;
  int endCoord;
  char *data;
} BedCoordData;

typedef struct {
  char chromName[CHROM_NAME_LEN + 1];
  int numCoords;
  //BedCoordData coords[MAX_BED_ITEMS];
  BedCoordData *coords;
} ChromBedData;

typedef struct {
  const Genome *genome;
  int numChroms;
  ChromBedData **chroms;
} BedData;

/* Function Prototypes */
BedData * readChromBedData(const char **bedFileNames, int numFiles, const Genome *genome);
void printBed(BedData *beds);
void freeBedData(BedData *beds);
void sortBedData(BedData *beds);
void numSortBedData(BedData *beds);
void lexSortBedData(BedData *beds);
int appendChromBedEntry(ChromBedData *chrom, int startPos, int endPos, char *data);
ChromBedData * initializeChromBedData(char * chromName);
BedData * initializeBedData(const Genome *genome);
int numCompareBedData(const void *pos1, const void *pos2);
int lexCompareBedData(const void *pos1, const void *pos2);



#endif /* BED_H */
