// Macro guard
#ifndef ASSERTIONMECHANISM_H
#define ASSERTIONMECHANISM_H

// Files included
#include "StandardFiles.hpp"

//==============================================================================
// Assert<ExcType>(bool, error)
//  A simple runtime assertion mechanism.  When assertion fails, throw ExcType.
//==============================================================================
template <typename ExcType>
struct Assert {
  /* NOTE: not default constructable */

  // Constructor
  Assert(bool b, const std::string& msg) {
    if ( b ) return;
    ExcType e(msg);
    throw(e);
  }

  // Constructor overload
  Assert(bool b, const std::string& msg1, const std::string& msg2) {
    Assert<ExcType>(b, msg1 + "\n" + msg2); // Call overload
  }
};

#endif // ASSERTIONMECHANISM_H

