// Macro Guard
#ifndef BEDMERGESORT_OUTPUT_H
#define BEDMERGESORT_OUTPUT_H

// Files included
#include "BedMergeSortDefinitions.hpp"
#include "BedMergeSortInput.hpp"
#include "Conversion.hpp"
#include "StandardFiles.hpp"

//========
// Output
//========
struct Output {
  Output(const std::string prefix, const Input& input)
                                     : input_(input),
                                       aCounter_(0), bCounter_(0),
                                       resultsFile_(input.FinalFile()) {

    using BedDefinitions::BedRow;
    using BedDefinitions::LexiOrder;
    const std::string finalResult = input.FinalFile();
    long maxFiles = input.MaxFiles();
    const long maxLines = input.MaxLines();
    std::ifstream inFile(input.InputFile().c_str());
    std::istream_iterator<BedRow> bl(inFile), eof;
    if ( bl == eof )
      return;

    long numLines = 0;
    long counter = 0;
    bool done = false;
    std::multiset<BedRow, LexiOrder> allRows;
    std::ofstream* current = new std::ofstream((prefix + "0").c_str());
    while ( bl != eof ) { // more input to break up
      if ( !bl->chrom_.empty() )
        allRows.insert(*bl++);
      else
        break;

      if ( ++numLines == maxLines ) { // another mini-file complete
        numLines = 0;
        std::copy(allRows.begin(), allRows.end(),
                  std::ostream_iterator<BedRow>(*current, "\n"));
        allRows.clear();
        current->close();
        delete current;
        std::string nextFile = prefix + convert<std::string>(++counter);
        if ( bl != eof )
          current = new std::ofstream(nextFile.c_str());
        else {
          --counter;
          done = true;
          break;
        }
      }
    } // while

    if ( !done ) { // another file to write
      std::copy(allRows.begin(), allRows.end(),
                std::ostream_iterator<BedRow>(*current, "\n"));
      current->close();
      delete current;
    }
    allRows.clear();

    // Call setops -u on intermediate files
    long next = 0;
    done = false;
    const std::string setops = "setops -u";
    while ( !done ) { // call setops -u[nion] again
      std::string call = setops;
      const std::string::size_type sz = call.size();
      long j = next;
      const long marker = next;
      for ( ; j < next + maxFiles; ++j ) {
        if ( j > counter )
          break;
        call += " " + prefix + convert<std::string>(j);
      } // for
      if ( sz == call.size() ) // nothing left
        break;
      next = j;
      call += " > " + prefix + convert<std::string>(++counter);
      if ( input.Verbose() )
        std::cerr << "System Call: " << call << std::endl;
      std::system(call.c_str());

      for ( long i = marker; i < next; ++i ) // remove unneeded files
        std::remove((prefix + convert<std::string>(i)).c_str());

      if ( j == counter )
        break;
    } // while

    std::string toRename = prefix + convert<std::string>(counter);
    std::rename(toRename.c_str(), finalResult.c_str());        
  }

private:
  const Input& input_;
  long aCounter_;
  long bCounter_;
  std::string resultsFile_;
};

#endif // BEDMERGESORT_OUTPUT_H
