// Macro Guard
#ifndef BEDDEFINITIONS_MERGESORTBED_H
#define BEDDEFINITIONS_MERGESORTBED_H

// Files included
#include "ByLine.hpp"
#include "StandardFiles.hpp"

namespace BedDefinitions {
  static const std::string CHROMOSOME = "chr";
  static const char SEP = '\t';

  //========
  // BedRow
  //========
  struct BedRow {
    std::string chrom_;
    std::pair<unsigned long, unsigned long> coords_;
    std::string rest_;

    friend std::ostream& operator<<(std::ostream& os, const BedRow& br) {
      os << CHROMOSOME << br.chrom_ << SEP << br.coords_.first << SEP
         << br.coords_.second;
      if ( !br.rest_.empty() )
        os << SEP << br.rest_;
      return(os);
    }

    friend std::istream& operator>>(std::istream& is, BedRow& bedRow) {
      ByLine br;
      is >> br;
      if ( br.empty() )
        return(is);
      std::string::size_type pos = br.find(SEP);
      std::string::size_type nex = br.find(SEP, ++pos);
      std::string::size_type las = br.find(SEP, ++nex);
      static const std::string::size_type sz = CHROMOSOME.size();
      bedRow.chrom_ = br.substr(sz, pos-sz-1);
      std::string::size_type st = bedRow.chrom_.size();
      for ( std::string::size_type i = 0; i < st; ++i )
        bedRow.chrom_[i] = toupper(bedRow.chrom_[i]); // case insensitive
      static const int b = 10;
      bedRow.coords_.first = strtoul(br.substr(pos, nex-pos-1).c_str(),
                                     NULL, b);
      if ( las != std::string::npos ) {
        bedRow.coords_.second = strtoul(br.substr(nex, las-nex).c_str(),
                                        NULL, b);
        bedRow.rest_ = br.substr(++las);
      }
      else
        bedRow.coords_.second = strtoul(br.substr(nex).c_str(), NULL, b);

      return(is);
    }
  };

  //=============
  // LexiOrder()
  //=============
  struct LexiOrder {
    bool operator()(const BedRow& r1, const BedRow& r2) {
      if ( r1.chrom_ != r2.chrom_ )
        return(r1.chrom_ < r2.chrom_);
      if ( r1.coords_.first != r2.coords_.first )
        return(r1.coords_.first < r2.coords_.first);
      return(r1.coords_.second < r2.coords_.second);
    }
  };

}

#endif // BEDDEFINITIONS_MERGESORTBED_H

