// Files included
#include "BedMergeSortDefinitions.hpp"
#include "BedMergeSortInput.hpp"
#include "BedMergeSortOutput.hpp"
#include "Conversion.hpp"
#include "StandardFiles.hpp"


//========
// main()
//========
int main(int argc, char** argv)
{
  typedef Input::InputError InputError;
  try {
    std::srand(std::time(NULL));
    std::string prefix = convert<std::string>(std::rand() % 100000) + "_";
    prefix = ".sortingtmp_" + prefix;
    Input input(argc, argv, prefix);
    Output output(prefix, input);
  } catch(InputError& ie) {
    std::cerr << ie.GetMessage() << std::endl;
    std::cerr << Input::Usage() << std::endl;
  } catch(...) {
    std::cerr << "Unknown exception" << std::endl;
  }
  return(0);
}
