/*
  FILE: sort.c
  AUTHOR: Scott Kuehn
  CREATE DATE: Thu Sep  7 08:48:35 PDT 2006
  PROJECT: CompBio
  ID: $Id: sort.c,v 1.4 2008/04/03 17:00:25 skuehn Exp $
*/


const char *usage = "USAGE: sort-bed [options] <file1.bed> <file2.bed> <...>        \n"
                    "        Sort the supplied bed files in lexigraphical order.    \n"
                    "        Outputs sorted result to stdout.                       \n";
//                    "       Options:                                                \n"
//                    "          -c: <genome> Sort in chromosone numeric order        \n"
//                    "              The <genome> is required, and must be one of     \n"
//                    "              human, mouse, chimp, dog, yeast, cow, rat,       \n"
//                    "              zebrafish, tetraodon, fugu, worm.                \n";
//
#include <stdlib.h>
#include <stdio.h>
#include <getopt.h>
#include <unistd.h>
#include <string.h>

#include "Bed.h"
#include "Genomes.h"

#define MAX_INFILES 10000

static void 
getArgs(int argc, char **argv, int *oldNumSort, 
	Genome *genome, const char **inFiles, int *numInFiles)
{
  int c, errflg = 0, numFiles, i, j, f1;
  extern char *optarg;
  extern int optind, optopt;

  /* Look at params */
  while ((c = getopt(argc, argv, "c:")) != -1) 
    {
    switch(c) 
      {
      case 'c':
	*oldNumSort = 1;

	if(strcmp(optarg, "human") == 0)
	  *genome = human;
	else if(strcmp(optarg, "mouse") == 0)
	  *genome = mouse;
	else if(strcmp(optarg, "chimp") == 0)
	  *genome = chimp;
	else if(strcmp(optarg, "dog") == 0)
	  *genome = dog;
	else if(strcmp(optarg, "yeast") == 0)
	  *genome = yeast;
	else if(strcmp(optarg, "cow") == 0)
	  *genome = cow;
	else if(strcmp(optarg, "rat") == 0)
	  *genome = rat;
	else if(strcmp(optarg, "zebrafish") == 0)
	  *genome = zebrafish;
	else if(strcmp(optarg, "tetraodon") == 0)
	  *genome = tetraodon;
	else if(strcmp(optarg, "fugu") == 0)
	  *genome = fugu;
	else if(strcmp(optarg, "worm") == 0)
	  *genome = worm;
	else
	  {
	    fprintf(stderr, "ERROR: %s is not a valid genome\n", optarg);
	    errflg++;
	  }

	break;
      case '?':
	errflg++;
      }
    }

  numFiles = argc - optind;
  if(numFiles < 1 || numFiles > MAX_INFILES) 
    {
      errflg++;
    }
  else
    {
      for(i = optind, j = 0; i < argc; i++, j++)
	{
	  // Check for stdin
	  if(strcmp(argv[i], "-") != 0) 
	    {
	      f1 = access(argv[i], R_OK);
	      if(f1)
		{
		  fprintf(stderr, "ERROR: %s is not accessible.\n", argv[i]);
		  exit(EXIT_FAILURE);
		}
	    }
	  inFiles[j] = argv[i];
	  (*numInFiles)++;
	}
    }

  if(errflg)
    {
      fprintf(stderr, "%s", usage);
      exit(EXIT_FAILURE);
    }
  return;
}


int
main(int argc, char **argv)
{

  int numSort = 0, numInFiles = 0;
  const char *inFiles[MAX_INFILES];
  Genome genome;
  BedData *tPD;
    
  getArgs(argc, argv, &numSort, 
	  &genome, inFiles, &numInFiles);

  if(numSort)
    {
      tPD = readChromBedData(inFiles, numInFiles, &genome);
      if(!tPD)
	exit(EXIT_FAILURE);
      numSortBedData(tPD);
    }
  else
    {
      tPD = readChromBedData(inFiles, numInFiles, NULL);
      if(!tPD)
	exit(EXIT_FAILURE);
      lexSortBedData(tPD);
    }

  printBed(tPD);
  
  exit(EXIT_SUCCESS);
}
