##
## Find FDR thresholds for hotspots (not peaks) and write out results.
## Run with R --no-save < run_thresh_hot.R
##

# A couple of R utilities for bed files.
source('_RLIB_')

mrgwid <- 150
tags <- "_TAGS_"
fdrs <- _FDRS_

rand <- "_RANDIR_"

report <- "_THRSH_RPT_"

file.remove(report)

fdrs <- as.numeric(unlist(strsplit(fdrs, split=" ")))

name <- basename(tags)
cat(name, '\n')
cat(name, '\n', file = report, append = T)
ntags <- read.table(paste(name, '-pass1/', name, '.stdout', sep = ''), as.is = T)[1,2]
ntagsr <- sprintf("%.0f", round(ntags/100000)*100000)
hoto <- read.table(paste(name, '-both-passes/', name, '.hotspot.twopass.zscore.wig', sep = ''), 
                   skip = 1, as.is = T, col.names = c('Chr', 'Start', 'Stop', 'z'))
hotr <- read.table(Sys.glob(paste(rand, '/', ntagsr, '-ran*both-passes/', ntagsr, '-ran.*hotspot.twopass.zscore.wig', sep = '')), 
                   skip = 1, as.is = T, col.names = c('Chr', 'Start', 'Stop', 'z'))
for(fdr in fdrs){
  if(fdr == 0)
    thz <- max(hotr$z)
  else{
    res <- uniroot(function(th) sum(hotr$z > th)/sum(hoto$z > th) - fdr, interval = c(3, 35), tol = .01)
    thz <- res$root
  }
  cat('fdr', fdr, 'z-score threshold =', thz, '-- number of thresholded hotspots =', sum(hoto$z > thz), '\n')
  cat('fdr', fdr, 'z-score threshold =', thz, '-- number of thresholded hotspots =', sum(hoto$z > thz), '\n', file = report, append = T)
  nm <- paste(name, '.hotspot.twopass.fdr', fdr, sep = '')
  trnm <- paste(name, '.hotspot.fdr', fdr, sep ='')
  bed <- paste(name, '-both-passes/', nm, '.bed', sep = '')
  wig <- gsub('bed$', 'wig', bed)
  mrgwig <- gsub('bed$', 'merge.wig', bed)
  cat('track type=wiggle_0 visibility=full name=', trnm, '\n', sep = '', file = wig)
  mrg <- hoto[hoto$z > thz,]
  write.table(mrg, file = bed, quote = F, sep = '\t', row.names = F, col.names = F)
  write.table(mrg, file = wig, quote = F, sep = '\t', row.names = F, col.names = F, append = T)
  mrg$Start <- pmax(mrg$Start - mrgwid/2, 0)
  mrg$Stop <- mrg$Stop + mrgwid/2
  mrg <- setops(mrg, 'm', sort = F)
  names(mrg) <- c('Chr', 'Start', 'Stop')
  mrg$Start <- mrg$Start + mrgwid/2
  mrg$Stop <- mrg$Stop - mrgwid/2
  mrgnm <- paste(nm, '.merge', sep = '')
  write.table(mrg, file = mrgwig, quote = F, sep = '\t', row.names = F, col.names = F)
  mrg$z <- read.table(pipe(paste('cut -f4', bed, '| paste', bed, '- | signalmap -max -% 0', mrgwig, '-')), as.is = T)[,1]
  cat('track type=wiggle_0 visibility=full name=', trnm, '\n', sep = '', file = mrgwig)
  write.table(mrg, file = mrgwig, quote = F, sep = '\t', row.names = F, col.names = F, append = T)
}
